<?php
session_start();
if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
    header('Location: admin_login.php');
    exit;
}
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['active_mode'])) {
    require '../backend/db.php';
    $active_mode = $_POST['active_mode'];
    $crash_level = isset($_POST['crash_level']) ? max(1, min(8, (int)$_POST['crash_level'])) : 5;
    $win_percent = isset($_POST['win_percent']) ? max(1, min(100, (int)$_POST['win_percent'])) : 70;
    $random_mode = ($active_mode === 'random') ? 1 : 0;
    $stmt = $conn->prepare('UPDATE game_settings SET crash_level=?, random_mode=?, win_percent=?, active_mode=? WHERE id=1');
    $stmt->bind_param('iiis', $crash_level, $random_mode, $win_percent, $active_mode);
    if ($stmt->execute()) {
        header('Location: ../admin/admin_dashboard.php?gs=ok');
    } else {
        header('Location: ../admin/admin_dashboard.php?gs=err');
    }
    $stmt->close();
    $conn->close();
    exit;
}
header('Location: admin_dashboard.php?gs=err');
exit; 